/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.launchConfigurations;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.launchConfigurations.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AdvancedSettingsTab
extends AbstractLaunchConfigurationTab {
    private Image image;
    private Button advancedRunEnabled;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.advancedRunEnabled = new Button(composite, 32);
        this.advancedRunEnabled.setText(Messages.AdvancedSettingsTab_EnableDebuggingInRunMode);
        Listener dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                AdvancedSettingsTab.this.setDirty(true);
                AdvancedSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.advancedRunEnabled.addListener(13, dirtyListener);
        this.setControl((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setAdvancedDefaults((ILaunchConfigurationWorkingCopy)configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.advancedRunEnabled.setSelection(configuration.getAttribute("advancedRunEnabled", false));
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("advancedRunEnabled", this.advancedRunEnabled.getSelection());
    }

    public String getName() {
        return Messages.AdvancedSettingsTab_Advanced;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JSDebugUIPlugin.getImageDescriptor("icons/full/obj16/launch-rundebug.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

